/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.webservices;

import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.adaptors.webservices.ByteArrayDataSource;
import filenet.vw.integrator.adaptors.webservices.IWSCall;
import filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptor;
import filenet.vw.integrator.adaptors.webservices.WSInvokeOperation;
import filenet.vw.integrator.adaptors.webservices.WSRequestOperation;
import filenet.ws.listener.axis.AxisFactorySettings;
import filenet.ws.listener.axis.SOAPMessageUtils;
import filenet.ws.listener.axis.rm.WSRMSequenceInfo;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.att.AttachmentHelper;
import filenet.ws.utils.att.IWSAttLoader;
import filenet.ws.utils.att.IWSAttSaver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.sandesha.SandeshaContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AxisCall
implements IWSCall {
    public static int rmMode = 0;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.WebServices.Call");
    private static final String m_className = "AxisCall";

    public static boolean getRMMode(boolean rm) {
        switch (rmMode) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return rm;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Dec 2008 10:17:52  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.35  $";
    }

    private static SOAPMessage callEx(SOAPConnection connection, SOAPMessage request, String endPoint, int wsTimeout, boolean oneWay, int rm, String wobNum) throws Exception {
        String m_method = "callEx:" + endPoint;
        Call call = null;
        SandeshaContext ctx = null;
        try {
            String[] soapActionURIs;
            logger.entering(m_className, m_method);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "oweWay = " + oneWay + "\n");
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "rm = " + rm + "\n");
            }
            call = new Call(endPoint);
            ((Message)request).setMessageContext(call.getMessageContext());
            SOAPEnvelope env = ((Message)request).getSOAPEnvelope();
            Attachments attachments = ((Message)request).getAttachmentsImpl();
            if (attachments != null) {
                for (Object attachment : attachments.getAttachments()) {
                    call.addAttachmentPart(attachment);
                }
            }
            call.setReturnClass(SOAPMessage.class);
            MimeHeaders headers = request.getMimeHeaders();
            String soapActionURI = null;
            if (headers != null && (soapActionURIs = request.getMimeHeaders().getHeader("SOAPAction")) != null) {
                call.setUseSOAPAction(true);
                soapActionURI = soapActionURIs[0];
                call.setSOAPActionURI(soapActionURI);
            }
            if (rm == 0) {
                call.setTimeout(new Integer(wsTimeout));
            } else {
                String targetHost;
                boolean bPE = false;
                String rmAction = null;
                short rmOperationType = 2;
                ctx = new SandeshaContext(true);
                long rmTimeout = WSRMUtils.getRMTimeout();
                call.setTimeout(new Integer((int)rmTimeout));
                if ((rm & 8) != 0) {
                    bPE = true;
                    rm -= 8;
                }
                rmAction = "!wobNum:" + wobNum + "!";
                switch (rm) {
                    case 1: {
                        rmAction = rmAction + "rm:oneWay";
                        rmOperationType = 2;
                        if (!logger.isFinest()) break;
                        logger.finest(m_className, m_method, "rm = RM_ONE_WAY");
                        break;
                    }
                    case 3: {
                        rmAction = rmAction + "rm:request";
                        rmOperationType = 2;
                        if (!logger.isFinest()) break;
                        logger.finest(m_className, m_method, "rm = RM_REQUEST");
                        break;
                    }
                    case 2: {
                        rmAction = rmAction + "rm:request.response";
                        rmOperationType = 1;
                        if (!logger.isFinest()) break;
                        logger.finest(m_className, m_method, "rm = RM_REQUEST_RESPONSE");
                        break;
                    }
                    case 4: {
                        rmAction = rmAction + "rm:reply";
                        rmOperationType = 2;
                        if (!logger.isFinest()) break;
                        logger.finest(m_className, m_method, "rm = RM_REPLY");
                        break;
                    }
                }
                if (!bPE) {
                    rmAction = soapActionURI + rmAction;
                }
                if ((targetHost = VWWebServicesAdaptor.gWSListenerProperties.getProperty("filenet.wsrm.client.listener.host")) == null || WSConstants.isLoopbackAddress(targetHost)) {
                    try {
                        targetHost = InetAddress.getLocalHost().getHostName();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                int targetPort = Integer.parseInt(VWWebServicesAdaptor.gWSListenerProperties.getProperty("filenet.wsrm.client.listener.port"));
                StringBuffer url = new StringBuffer();
                url.append("http://").append(targetHost).append(":").append(targetPort).append("/axis/services").append("/RMService");
                String RMServiceURL = url.toString();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "RMServiceURL = " + RMServiceURL);
                }
                ctx.setSourceURL(RMServiceURL);
                ctx.setReplyToURL(RMServiceURL);
                ctx.setFromURL(RMServiceURL);
                ctx.setAcksToURL(RMServiceURL);
                ctx.initCall(call, endPoint, rmAction, rmOperationType);
                if (soapActionURI != null && soapActionURI.length() != 0) {
                    call.setProperty("action", (Object)soapActionURI);
                }
                ctx.setLastMessage(call);
            }
            call.invoke(env);
            Message message = call.getResponseMessage();
            return message;
        }
        catch (MalformedURLException mue) {
            throw new SOAPException((Throwable)mue);
        }
        catch (AxisFault af) {
            if (oneWay && af.getMessage().indexOf("Premature") > -1 && call != null && call.getMessageContext().getResponseMessage() != null) {
                SOAPMessage sOAPMessage = null;
                return sOAPMessage;
            }
            throw new SOAPException((Throwable)af);
        }
        catch (RemoteException re) {
            throw new SOAPException((Throwable)re);
        }
        finally {
            if (ctx != null) {
                ctx.endSequence();
            }
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeSOAPViaSAAJ(WSRequestOperation op, String soapAction, String soapAddress, String soapHeaders, String replyHeader, boolean isDocument, boolean oneWay, int rm, String wobNum, String bindingInputNS, IWSAttLoader[] docs) throws Exception {
        String m_method = "invokeSOAPViaSAAJ";
        AxisFactorySettings soapFactorySettings = new AxisFactorySettings();
        try {
            logger.entering(m_className, "invokeSOAPViaSAAJ");
            op.m_wsLogger.append("soapAddress=").append(soapAddress).eoln();
            op.m_wsLogger.append("soapAction=").append(soapAction).eoln();
            if (logger.isFinest()) {
                logger.finest(m_className, "invokeSOAPViaSAAJ", "soapAddress=" + soapAddress);
                logger.finest(m_className, "invokeSOAPViaSAAJ", "soapAction=" + soapAction);
            }
            String envPrefix = (String)op.m_namespaces.get("http://schemas.xmlsoap.org/soap/envelope/");
            String sEnv = envPrefix + ":Envelope";
            String sBody = envPrefix + ":Body";
            String sHeader = envPrefix + ":Header";
            String sFault = envPrefix + ":Fault";
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version='1.0' encoding='UTF-8'?><").append(sEnv);
            Enumeration nsPrefixes = op.m_namespaces.keys();
            while (nsPrefixes.hasMoreElements()) {
                String nsValue = (String)nsPrefixes.nextElement();
                String nsPrefix = (String)op.m_namespaces.get(nsValue);
                buf.append(" xmlns:").append(nsPrefix).append("=\"").append(nsValue).append("\"");
            }
            buf.append(">");
            if (soapHeaders != null || replyHeader != null) {
                buf.append("<").append(sHeader).append(">");
                if (replyHeader != null) {
                    buf.append(replyHeader);
                }
                if (soapHeaders != null) {
                    buf.append(soapHeaders);
                }
                buf.append("</").append(sHeader).append(">");
            }
            buf.append("<").append(sBody);
            String wrapperElement = null;
            if (isDocument) {
                buf.append(">");
            } else {
                buf.append(" ").append(envPrefix).append(":encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
                String opNSPrefix = (String)op.m_namespaces.get(bindingInputNS);
                String opNS = ">";
                if (opNSPrefix == null) {
                    opNSPrefix = "q1";
                    while (op.m_wsDefinition.getNamespace(opNSPrefix) != null) {
                        opNSPrefix = opNSPrefix + "x";
                    }
                    opNS = " xmlns:" + opNSPrefix + "=\"" + bindingInputNS + "\">";
                }
                wrapperElement = opNSPrefix + ":" + op.m_op;
                buf.append("<").append(wrapperElement).append(opNS);
            }
            if (op.m_fault != null && op.m_fault.length() > 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "invokeSOAPViaSAAJ", "sending fault..");
                }
                buf.append("<").append(sFault).append("><faultcode>").append(op.m_fault).append("</faultcode>").append("<faultstring>").append(op.m_inputMsg).append("</faultstring></").append(sFault).append(">");
            } else {
                buf.append(op.m_inputMsg);
            }
            if (!isDocument) {
                buf.append("</").append(wrapperElement).append(">");
            }
            buf.append("</").append(sBody).append("></").append(sEnv).append(">");
            if (logger.isFinest()) {
                logger.finest(m_className, "invokeSOAPViaSAAJ", "SOAPMessage=" + buf.toString());
            }
            op.m_wsLogger.append("SOAPMessageRequest=" + buf).eoln();
            SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = scFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(buf.toString().getBytes("UTF-8")));
            message.getMimeHeaders().addHeader("SOAPAction", soapAction);
            if (logger.isLoggable(Level.FINEST) && logger.isFinest()) {
                logger.finest(m_className, "invokeSOAPViaSAAJ", "scFactory class=" + scFactory.getClass().getName() + ", msgFactory class=" + messageFactory.getClass().getName() + ", message class=" + message.getClass().getName());
            }
            int nDocs = 0;
            if (docs != null) {
                nDocs = docs.length;
                for (int i = 0; i < nDocs; ++i) {
                    try {
                        if (logger.isFinest()) {
                            logger.finest(m_className, "invokeSOAPViaSAAJ", "attaching: " + docs[i].toString());
                        }
                        AttachmentPart attach = this.getAttachmentPart(message, docs[i]);
                        message.addAttachmentPart(attach);
                        continue;
                    }
                    catch (Exception e) {
                        logger.throwing(m_className, "invokeSOAPViaSAAJ", e);
                    }
                }
            }
            op.m_wsLogger.append("Request Attachment Count=" + Integer.toString(nDocs)).eoln();
            op.m_wsLogger.append("oneWay = " + oneWay).eoln();
            op.m_wsLogger.append("rm = " + rm).eoln();
            SOAPMessage response = AxisCall.callEx(connection, message, soapAddress, op.m_wsTimeout, oneWay, rm, wobNum);
            if (oneWay && response == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "invokeSOAPViaSAAJ", "Oneway message");
                }
                return;
            }
            if (rm != 2 && response == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "invokeSOAPViaSAAJ", "RM oneway message");
                }
                return;
            }
            SOAPBody responseBody = response.getSOAPPart().getEnvelope().getBody();
            if (logger.isFinest()) {
                logger.finest(m_className, "invokeSOAPViaSAAJ", "responseBody.toString=" + responseBody.toString());
            }
            String responseBodyString = SOAPMessageUtils.getBodyChildElementsAsString(responseBody);
            op.m_wsLogger.append("Response SOAP Body=" + responseBodyString).eoln();
            if (responseBody.hasFault()) {
                WSRMSequenceInfo seqInfo;
                String rmExtraDetails = null;
                if (rm != 0 && wobNum != null && (seqInfo = WSRMSequenceInfo.getSequenceInfoByWobnum(wobNum)) != null) {
                    rmExtraDetails = seqInfo.getSeqStatusMsg();
                }
                SOAPFault soapFault = responseBody.getFault();
                op.m_fault = soapFault.getFaultCode();
                NodeList nl = soapFault.getChildNodes();
                int nNodes = nl == null ? 0 : nl.getLength();
                for (int i = 0; i < nNodes; ++i) {
                    Node n = nl.item(i);
                    if (n == null || !n.getNodeName().equals("detail") || !n.hasChildNodes()) continue;
                    NodeList nl2 = n.getChildNodes();
                    Node n2 = nl2.item(0);
                    op.m_fault = n2.getLocalName();
                }
                op.m_outputMsg = soapFault.getFaultString();
                if (rmExtraDetails != null) {
                    op.m_outputMsg = op.m_outputMsg + "\n" + rmExtraDetails;
                }
                op.m_wsLogger.append("fault=" + op.m_fault + ", detail=" + op.m_outputMsg).eoln();
                logger.warning(m_className, "invokeSOAPViaSAAJ", "Response Has FAULT: " + soapFault.toString());
                return;
            }
            if (!op.m_wsdlIsFromPE && op.m_validateMessages) {
                try {
                    op.validate(responseBodyString);
                }
                catch (Throwable t) {
                    logger.throwing(m_className, "invokeSOAPViaSAAJ", t);
                }
            }
            int nAttachments = response.countAttachments();
            op.m_wsLogger.append("Response Attachment Count=" + Integer.toString(nAttachments)).eoln();
            if (op instanceof WSInvokeOperation && op.m_wsFolder != null && op.m_WSAttSession != null && nAttachments > 0) {
                try {
                    IWSAttSaver saver = op.m_WSAttSession.getSaver(op.m_wsFolder.getLibraryName(), op.m_wsFolder.getId());
                    String titlePrefix = new VWString("filenet.vw.integrator.adaptors.ws.Invoke", "WS Invoke Response from {0}, {1}, {2}").toString(soapAddress, op.m_portType, op.m_op);
                    AttachmentHelper.storeAttachments(response, saver, titlePrefix, op.m_wsLogger);
                }
                catch (Exception e) {
                    logger.throwing(m_className, "invokeSOAPViaSAAJ", e);
                }
            }
            op.m_outputMsg = isDocument ? responseBodyString : SOAPMessageUtils.getRPCBodyChildElementsAsString(responseBody, op.m_rpcOutAccessors, op.m_rpcOutMsgParts);
            op.m_wsLogger.append("OutputMsg=" + op.m_outputMsg).eoln();
            if (logger.isFinest()) {
                logger.finest(m_className, "invokeSOAPViaSAAJ", "outputMsg=" + op.m_outputMsg);
            }
        }
        finally {
            logger.exiting(m_className, "invokeSOAPViaSAAJ");
            soapFactorySettings.reset();
        }
    }

    private AttachmentPart getAttachmentPart(SOAPMessage message, IWSAttLoader docLoader) throws Exception {
        boolean useStream;
        if (docLoader == null) {
            throw new Exception("No loader for getting attachment.");
        }
        AttachmentPart attach = null;
        boolean bl = useStream = System.getProperty("filenet.ws.att.useStream") != null;
        if (!useStream) {
            byte[] byteData = docLoader.getContents();
            if (byteData != null) {
                attach = message.createAttachmentPart();
                attach.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource("Test Data" + docLoader.getId(), byteData, docLoader.getMimeType())));
                attach.setContentId(docLoader.getId());
                return attach;
            }
        } else {
            InputStream[] in = docLoader.getContentStreams();
            if (in != null && in[0] != null) {
                attach = message.createAttachmentPart();
                attach.setContent((Object)in[0], docLoader.getMimeType());
                attach.setContentId(docLoader.getId());
                return attach;
            }
        }
        throw new Exception("Unable to get AttachmentPart");
    }
}

